unit Main;

//      - .
//        ,
//    .

//=============================================
interface
uses
  Windows, Messages, SysUtils, Variants, Classes,
  Graphics, Controls, Forms, Dialogs, StdCtrls, ExtCtrls;
//=============================================
type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
var
  Form1: TForm1;
//=============================================
implementation
{$R *.dfm}


//=============================================
//   TOBJ1
type TQItem = class (TObject)
  private
    fPNext  : pointer;                     //    
    fSData  : array[1..3,1..3] of double;  //  
    //   
    function  GetDataFromOBJ(Row, Col : integer) : double;
    procedure SetDataToOBJ(Row, Col : integer; RqSData : double);
    function  GetPNextFromOBJ() : pointer;
    procedure SetPNextToOBJ(RqPNext : pointer);
  public
    //  
    property PNext : pointer read GetPNextFromOBJ write SetPNextToOBJ;
    //   - 
    property SData[Row, Col : integer] : double
        read GetDataFromOBJ write SetDataToOBJ; default;
    //        
    procedure PropShow(RqReport : TMemo); virtual;
end;

//=============================================
var Obj1 : TQItem;   //    
//=============================================

//    TOBJ1
//    
procedure TQItem.SetDataToOBJ(Row, Col : integer; RqSData : double);
begin
  if (Row >= Low(fSData)) and (Row <= High(fSData))
  then begin
     if (Col >= Low(fSData[Row])) and (Col <= High(fSData[Row]))
     then begin
         fSData[Row, Col] := RqSData;
     end
     else ShowMessage(' Col   ');
  end
  else ShowMessage(' Row   ');
end;

//      
function  TQItem.GetDataFromOBJ(Row, Col : integer) : double;
begin
  Result := 0;
  if (Row >= Low(fSData)) and (Row <= High(fSData))
  then begin
     if (Col >= Low(fSData[Row])) and (Col <= High(fSData[Row]))
     then begin
         Result := fSData[Row, Col];
     end
     else ShowMessage(' Col   ');
  end
  else ShowMessage(' Row   ');
end;

//         
procedure TQItem.SetPNextToOBJ(RqPNext : pointer);
begin
  if Assigned(RqPNext)
  then begin
     try
        //  RqPNext    
        //  IS   
        if TObject(RqPNext) is TQItem
        then fPNext := RqPNext
        else begin
           fPNext := nil;
           ShowMessage ( format('%p',[RqPNext])
                       + ' -     '
                       + TObject(RqPNext).ClassName
                       + #13
                       + '      ');
        end;
     except
        fPNext := nil;
        ShowMessage ( format('%p',[RqPNext])
                     + ' -     '
                     + #13
                     + '      ');
     end;
  end
  else fPNext := nil;
end;

//      
function  TQItem.GetPNextFromOBJ() : pointer;
begin Result := fPNext; end;

//        
procedure TQItem.PropShow(RqReport : TMemo);
var P1         : pointer;        //  
    wRow, wCol : integer;
begin
   P1 := Self;
   RqReport.Lines.Add('  = ' + format('%p',[P1]));
   if Assigned(fPNext)
   then RqReport.Lines.Add(' fPNext = ' + format('%p',[fPNext]))
   else RqReport.Lines.Add(' fPNext = NIL');
   //     fSData
   RqReport.Lines.Add('   -  :');
   for wRow := Low(fSData) to High(fSData)
   do begin
      RqReport.Lines.Add(' : ' + IntToStr(wRow));
      for wCol := Low(fSData[wRow]) to High(fSData[wRow])
      do begin
         RqReport.Lines.Add(FloatToStr(fSData[wRow, wCol]));
      end;
   end;
end;

//=============================================
// 
procedure TForm1.Button1Click(Sender: TObject);
var wRow, wCol : integer;
begin
   for wRow := 1 to 3
   do begin
      for wCol := 1 to 3
      do begin
         Obj1.SData[wRow, wCol]:= wRow * wCol;
      end;
   end;
   Memo1.Clear;
   Obj1.PropShow(Memo1);
end;

//    
procedure TForm1.FormCreate(Sender: TObject);
var wRow, wCol : integer;
begin
   Obj1 := TQItem.Create;
   Obj1.PNext := nil;
   //     fSData
   for wRow := 1 to 3
   do begin
      for wCol := 1 to 3
      do begin
         Obj1[wRow, wCol]:= 0;
      end;
   end;
   Memo1.Clear;
   Obj1.PropShow(Memo1);
end;

//  
procedure TForm1.FormDestroy(Sender: TObject);
begin
   Obj1.Free;
end;

end.
